//  -*- Mode: C++;  -*-

//  File: area_class.h

//  Author: Dino Bellugi (dino@geomorph.berkeley.edu)

//  Copyright  Dino Bellugi, BlueG SoftWear, U.C. Berkeley, 1999 (C)

// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// * FUNCTION: Computes the contributing area value for each

// *           cell. Contributing area is calculated using an

// *           8 neighbour slope (tan) weighted function.

// * CLASSES:  Contributing_Area

// * 

// * RELATED PACKAGES: Grid

// *

// * HISTORY:

// * Created:  Wed Jul 21 1993 (dino, based on rob reiss' version)

// * Modified: Sat Jun 26 1999 (dino)

// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



#ifndef	DEF_AREA

#define	DEF_AREA



// the following include file (notice.h) contains important copyright 

// information, as well as other legal statements. it must be present 

// in all files and in any distribution. removal or modification is

// strictly forbidden and violates u.s. and international copyright law.

#include "notice.h"

//

#include "grid.h"

#include "macros.h"



#define CA_AOVERB	0	// area/spacing

#define CA_AREA		1	// area

#define CA_MESSAGES	1	// 0 = no messages, 1 = level 1 messages, etc.

#define CA_SORT		0	// 0 = no sorting, 1 = sort by elevation

#define CA_MODE	CA_AOVERB	// default mode



// classes

class Contributing_Area

{

private:

	GridEdges *pWeights;

        Grid *pGrd;

	void makeWeights(int field = 0, int disp = CA_MESSAGES);  

	double getContributingArea(int i,int j, int field = 1);  

	void initContributingArea(int infield = 0, int outfield = 1,

		int mode = CA_MODE, int disp = CA_MESSAGES);

#if (CA_SORT)

	void sortIndex(int field, int disp);  

	int getIndI(long int n)	{return((int)(n % pGrd->xdim));}

	int getIndJ(long int n)	{return((int)(n / pGrd->xdim));}

	int *pSInd;

#endif

public:

	Contributing_Area(Grid *ingrd, int infield = 0, int outfield = 1,

		int mode = CA_MODE, int check = TRUE, int *sinks = (int *)NULL,
		
		int disp = CA_MESSAGES);

	~Contributing_Area();

};



#endif

